import QtQuick 2.15
import QtQuick.Window 2.12
import QtQuick.Controls 2.5
import QtQuick.Dialogs 1.1

import CStore 1.0

MessageDialog {
    property var dialogWidth: 240
    property var dialogHeight: 175
    property var editingStaff
    property var isEditMode: editingStaff != null // true: edit mode, false: add mode

    StoreQml.onDispatched: {
        //Todo
    }

    onEditingStaffChanged: {
        staffNameTextField.text = editingStaff != null ? editingStaff.name : ""
        departmentTextField.text = editingStaff != null ? editingStaff.department : ""
        yearsNumTextField.text = editingStaff != null ? editingStaff.yearsOfWork : ""
    }

    title: isEditMode ? "Edit Staff" : "Add Staff"
    Component.onCompleted: {
        width = dialogWidth
        height = dialogHeight
    }


    Rectangle {
        TextField {
            id: staffNameTextField
            placeholderText: "Name"
            height: 30
            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
                margins: 10
            }
            text: editingStaff != null ? editingStaff.name : ""
            validator: RegularExpressionValidator { regularExpression: /^[0-9A-Za-z _]+/ }
        }

        TextField {
            id: departmentTextField
            placeholderText: "Department"
            height: 30
            anchors {
                top: staffNameTextField.bottom
                left: parent.left
                right: parent.right
                margins: 10
            }
            text: editingStaff != null ? editingStaff.department : ""
            validator: RegularExpressionValidator { regularExpression: /^[0-9A-Za-z _]+/ }
        }

        TextField {
            id: yearsNumTextField
            placeholderText: "Years Of Work"
            height: 30
            anchors {
                top: departmentTextField.bottom
                left: parent.left
                right: parent.right
                margins: 10
            }
            text: editingStaff != null ? editingStaff.yearsOfWork : ""
            validator: RegularExpressionValidator { regularExpression: /^[0-9]+/ }
        }

        Button {
            id: updateButton
            width: 100
            height: 30
            text: isEditMode ? "Update" : "Add"
            enabled: staffNameTextField.text != "" &&
                     departmentTextField.text != "" &&
                     yearsNumTextField.text != ""
            anchors {
                top: yearsNumTextField.bottom
                left: parent.left
                margins: 10
            }
            onClicked: {
                if(isEditMode)
                {
                    editingStaff.name = staffNameTextField.text
                    editingStaff.department = departmentTextField.text
                    editingStaff.yearsOfWork = yearsNumTextField.text
                    // 100 is request update staff
                    appDispatcher.dispatchQml(ActionType.StaffManagementPage_UpdateStaff, editingStaff)
                }
                else
                {
                    var newStaff = [staffNameTextField.text, departmentTextField.text, yearsNumTextField.text].join(";")
                    // 102 is request adding staff
                    appDispatcher.dispatchQml(ActionType.StaffManagementPage_AddStaff, newStaff)
                    // reset UI
                    staffNameTextField.text = ""
                    departmentTextField.text = ""
                    yearsNumTextField.text = ""
                }
            }
        }

        Button {
            id: closeButton
            width: 100
            height: 30
            text: "Close"
            anchors {
                top: yearsNumTextField.bottom
                right: parent.right
                margins: 10
            }
            onClicked: {
                close()
            }
        }
    }
}
