import QtQuick 2.12
import QtQuick.Window 2.12
import QtQuick.Controls 2.5
import QtQuick.Dialogs 1.1

import CStore 1.0

Item {
    readonly property var staffListStore: StoreQml.store.storeStaffList

    StoreQml.onDispatched: {
        console.log("StaffManagepage.qml type:" + type)
        if(type === ActionType.StaffManagementPage_Load ||
           type === ActionType.StaffManagementPage_UpdateStaff ||
           type === ActionType.StaffManagementPage_DelStaff ||
           type === ActionType.StaffManagementPage_AddStaff)
        {
            if(payload === true)
            {
                //GetList
                itemList.model = staffListStore.lstStaffs
            }
        }
    }

    Rectangle {
        id: itemListNameHeader
        height: 30
        width: parent.width / 3
        anchors {
            left: parent.left
            leftMargin: 10
            top: parent.top
            topMargin: 10
        }
        color: "orange"
        Text {
            width: parent.width
            anchors {
                verticalCenter: parent.verticalCenter
            }
            text: "Name"
            elide: Text.ElideRight
            color: "#000000"
            font.pixelSize: 14
        }
    }

    Rectangle {
        id: itemListDepartmentHeader
        height: 30
        width: parent.width / 3
        anchors {
            left: itemListNameHeader.right
            top: itemListNameHeader.top
        }
        color: "orange"
        Text {
            width: parent.width
            anchors {
                verticalCenter: parent.verticalCenter
            }
            text: "Department"
            elide: Text.ElideRight
            color: "#000000"
            font.pixelSize: 14
        }
    }

    Rectangle {
        id: itemListYearsNumHeader
        height: 30
        anchors {
            left: itemListDepartmentHeader.right
            top: itemListDepartmentHeader.top
            right: addButtonRect.left
        }
        color: "orange"
        Text {
            width: parent.width
            anchors {
                verticalCenter: parent.verticalCenter
            }
            text: "Years Of Work"
            elide: Text.ElideRight
            color: "#000000"
            font.pixelSize: 14
        }
    }

    Rectangle {
        id: addButtonRect
        width: 30
        height: 30
        anchors {
            top: itemListYearsNumHeader.top
            right: parent.right
            rightMargin: 10
        }
        color: "orange"

        Button {
            id: addButton
            anchors.fill: parent
            anchors.margins: 3
            text: "+"
            onClicked: {
                staffDetailsDialog.editingStaff = null
                staffDetailsDialog.open()
            }
        }
    }

    ListView {
        id: itemList
        flickableDirection: Flickable.VerticalFlick
        boundsBehavior: Flickable.StopAtBounds
        ScrollBar.vertical: ScrollBar {
            id: itemListScrollBar
            visible: itemList.height < itemList.contentHeight ? true:false
            contentItem:  Rectangle {
                color: "#8025b5b9"
                radius: 3
            }
            width: 10
        }

        anchors {
            top: itemListNameHeader.bottom
            left: itemListNameHeader.left
            right: parent.right
            bottom: parent.bottom
            bottomMargin: 10
        }

        clip: true
        focus: true
        delegate: Rectangle {
            id: staffItemRect
            width: itemList.width - itemListScrollBar.width
            height: 30
            color: ListView.isCurrentItem ? "#25b5b9" : index % 2 == 0 ? "#A6A6A6" : "#D9D9D9"

            MouseArea {
                id: trainItemMouseArea
                anchors.fill: parent
                hoverEnabled: true
                onClicked: {
                    itemList.currentIndex = index
                    itemList.forceActiveFocus() // force focus to allow arrow Keys navigation
                }
            }

            Text {
                id: staffName
                width: itemListNameHeader.width
                anchors {
                    verticalCenter: staffItemRect.verticalCenter
                }
                text: modelData.name
                elide: Text.ElideRight
                color: "#000000"
                font.pixelSize: 14
            }

            Text {
                id: department
                width: itemListDepartmentHeader.width
                anchors {
                    left: staffName.right
                    verticalCenter: staffItemRect.verticalCenter
                }
                text: modelData.department
                elide: Text.ElideRight
                color: "#000000"
                font.pixelSize: 14
            }

            Text {
                id: yearsOfWork
                width: itemListYearsNumHeader.width - editButton.width - deleteButton.width
                anchors {
                    left: department.right
                    verticalCenter: staffItemRect.verticalCenter
                }
                text: modelData.yearsOfWork
                elide: Text.ElideRight
                color: "#000000"
                font.pixelSize: 14
            }

            Button {
                id: editButton
                height: staffItemRect.height
                width: height
                palette {
                    button: "transparent"
                }

                anchors {
                    right: deleteButton.left
                    rightMargin: 2
                    verticalCenter: staffItemRect.verticalCenter
                }
                onClicked: {
//                    deleteSingleImageConfirmDialog.imagePath = imagePath
//                    deleteSingleImageConfirmDialog.visible = true
                    staffDetailsDialog.editingStaff = modelData
                    staffDetailsDialog.open()
                }
                Image {
                    id: editIcon
                    anchors {
                        fill: parent
                        margins: 1
                    }
                    fillMode: Image.Stretch
                    source: "../Edit.svg"
                }
            }

            Button {
                id: deleteButton
                height: staffItemRect.height
                width: height
                palette {
                    button: "transparent"
                }

                anchors {
                    right: staffItemRect.right
                    verticalCenter: staffItemRect.verticalCenter
                }
                onClicked: {
//                    deleteSingleImageConfirmDialog.imagePath = imagePath
//                    deleteSingleImageConfirmDialog.visible = true
                    deleteConfirmationDialog.deleteStaff = modelData
                    deleteConfirmationDialog.open()
                }
                Image {
                    id: deleteIcon
                    anchors {
                        fill: parent
                        margins: 1
                    }
                    fillMode: Image.Stretch
                    source: "../Delete.svg"
                }

                Popup {
                    id: popup

                    parent: Overlay.overlay

                    x: Math.round((parent.width - width) / 2)
                    y: Math.round((parent.height - height) / 2)
                    width: 100
                    height: 100
                }
            }
        }
    }

    MessageDialog {
        property var deleteStaff

        id: deleteConfirmationDialog
        title: "Delete Confirmation"
        text: "Do you really want to delete this staff ?"
        icon: "Warning"
        standardButtons: StandardButton.No | StandardButton.Yes
        onYes: {
            if(deleteStaff != null)
            {
                appDispatcher.dispatchQml(ActionType.StaffManagementPage_DelStaff, deleteStaff)
            }
        }
    }

    StaffDetailsDialog {
        id: staffDetailsDialog
    }
}
