#ifndef ACTIONTYPES_H
#define ACTIONTYPES_H

#include <QObject>
#include <QtQml>
#include <QDebug>

class CActionType: public QObject
{
    Q_OBJECT

public:
    explicit CActionType(QObject *parent = 0) {Q_UNUSED(parent)};
    enum ActionType {
        MainScreen = 1000,
        MainScreen_Load,

        // StaffManagement Screen
        StaffManagementPage,
        StaffManagementPage_Load,
        StaffManagementPage_Save,
        StaffManagementPage_UpdateStaff,
        StaffManagementPage_AddStaff,
        StaffManagementPage_DelStaff,


    };
    Q_ENUM(ActionType)
    static void registerQmlType(){
        qmlRegisterUncreatableType<CActionType>("CStore", 1, 0, "ActionType", "Err!");
    }

    friend QDebug operator<<(QDebug debug, const CActionType::ActionType type)
    {
        QDebugStateSaver saver(debug);
        QString strType = QVariant::fromValue(type).toString();
        debug.nospace() << strType;
        return debug;
    }
};
Q_DECLARE_METATYPE(CActionType::ActionType)
#endif // ACTIONTYPES_H
