#include "cmainservice.h"
#include "actiontypes.h"
#include "stafflistdbfile.h"
#include "qtflux/cdispatcher.h"
#include "cmainstore.h"
#include <QSharedPointer>

CMainService::CMainService(QObject *parent):CService(parent)
{

}

QSharedPointer<CAction> CMainService::process(const QSharedPointer<CAction> &action)
{
    // Load Staff List From File
    if(action->actionType() == CActionType::StaffManagementPage_Load)
    {
        QSharedPointer<CMainStore>  mainStore = qobject_cast<QSharedPointer<CMainStore>>(CDispatcher::instance().getMainStore());
        CStoreStaffList *staffls = mainStore->staffList();

        QList<Staff*> result;
        StaffListDBFile::loadStaffListFromFile("StaffList.txt", result);
        staffls->setStaffList(result);
        action->setValue(true);
        return action;
    }

    // Save Staff List To File
    if(action->actionType() == CActionType::StaffManagementPage_Save)
    {
        QSharedPointer<CMainStore>  mainStore = qobject_cast<QSharedPointer<CMainStore>>(CDispatcher::instance().getMainStore());
        CStoreStaffList *staffls = mainStore->staffList();
        QList<Staff*> result = staffls->staffList();
        StaffListDBFile::writeStaffListToFile("StaffList.txt", result);
        action->setValue(true);
        return action;
    }
    return action;
}
