#include "cmainstore.h"
#include "actiontypes.h"

CMainStore::CMainStore(QObject *parent ):CStore(parent)
{
    CStoreStaffList::registerQmlType();
    m_staffList.reset(new CStoreStaffList(this));
}

QSharedPointer<CAction> CMainStore::process(const QSharedPointer<CAction> &action)
{
    QSharedPointer<CAction> rsp = action;
    switch (action->actionType()) {
    case CActionType::StaffManagementPage:
    case CActionType::StaffManagementPage_Load:
    case CActionType::StaffManagementPage_Save:
    case CActionType::StaffManagementPage_AddStaff:
    case CActionType::StaffManagementPage_DelStaff:
    case CActionType::StaffManagementPage_UpdateStaff:
    {
        rsp = m_staffList->process(action);
    }break;
    default:
    {

    }break;
    };
    emit dispatched(rsp->actionType(),rsp->value());
    return rsp;
}

CStoreStaffList *CMainStore::staffList() const
{
    return m_staffList.data();
}

