#ifndef CMAINSTORE_H
#define CMAINSTORE_H

#include <QObject>
#include "./qtflux/cstore.h"
#include "cstorestafflist.h"

using namespace qtflux;
class CMainStore : public CStore
{
    Q_OBJECT
    Q_PROPERTY(CStoreStaffList* storeStaffList READ staffList NOTIFY staffListChanged)
public:
    CMainStore(QObject *parent = nullptr);
    QSharedPointer<CAction> process(const QSharedPointer<CAction>& action ) override;

    CStoreStaffList *staffList() const;

private:
    QSharedPointer<CStoreStaffList>     m_staffList;


signals:
    void staffListChanged();
};

#endif // MAINSTORE_H
