#include "cstorestafflist.h"
#include "qtflux/cdispatcher.h"

CStoreStaffList::CStoreStaffList(QObject *parent ):CStore(parent)
{
    qDebug() << "Contructor CStoreStaffList"  << this;
    connect(this, &CStoreStaffList::staffListChanged, this, &CStoreStaffList::onSaveStaffListFile);
}

CStoreStaffList::CStoreStaffList(const CStoreStaffList &staffList, QObject *parent):CStoreStaffList(parent)
{
    this->m_staffList = staffList.m_staffList;
}

QList<Staff*> CStoreStaffList::staffList() const
{
    return m_staffList;
}

void CStoreStaffList::setStaffList(const QList<Staff*> &staffList)
{
    // free current memory
    foreach(Staff* st, m_staffList)
    {
        st->deleteLater();
    }
    m_staffList.clear();

    // set staff list
    m_staffList = staffList;
    staffListChanged();
}

void CStoreStaffList::onSaveStaffListFile()
{
    CDispatcher::instance().dispatch(CActionType::StaffManagementPage_Save,"");
}

QSharedPointer<CAction> CStoreStaffList::process(const QSharedPointer<CAction> &action)
{

    // Update Staff Information
    if(action->actionType() == CActionType::StaffManagementPage_UpdateStaff)
    {
        Staff* newStaffValue = qvariant_cast<Staff*>(action->value());

        // Find and update staff by id
        foreach(Staff* item, m_staffList)
        {
            if(item->id() == newStaffValue->id())
            {
                item->setName(newStaffValue->name());
                item->setDepartment(newStaffValue->department());
                item->setYearsOfWork(newStaffValue->yearsOfWork());
                emit staffListChanged();
                break;
            }
        }

        action->setValue(true);
        return action;
    }

    // Delete Staff
    if(action->actionType() == CActionType::StaffManagementPage_DelStaff)
    {
        Staff* deleteStaffValue = qvariant_cast<Staff*>(action->value());

        // Find and update staff by id
        foreach(Staff* item, m_staffList)
        {
            if(item->id() == deleteStaffValue->id())
            {
                m_staffList.removeOne(item);
                item->deleteLater();
                emit staffListChanged();
                break;
            }
        }

        action->setValue(true);
        return action;
    }

    // Adding Staff
    if(action->actionType() == CActionType::StaffManagementPage_AddStaff)
    {
        QStringList staffStr = action->value().toString().split(";");
        if(staffStr.size() >= 3)
        {
            Staff* newStaff = new Staff();
            newStaff->setId(QUuid::createUuid());
            newStaff->setName(staffStr[0]);
            newStaff->setDepartment(staffStr[1]);
            newStaff->setYearsOfWork(staffStr[2].toInt());
            m_staffList.push_back(newStaff);
            emit staffListChanged();
        }

        action->setValue(true);
        return action;
    }

    return action;
}
