#ifndef CSTORESTAFFLIST_H
#define CSTORESTAFFLIST_H

#include <QObject>
#include "qtflux/caction.h"
#include "qtflux/cstore.h"
#include "staff.h"
#include "actiontypes.h"

using namespace qtflux;
class CStoreStaffList : public CStore
{
    Q_OBJECT
    Q_PROPERTY(QList<Staff*> lstStaffs READ  staffList)
public:
    CStoreStaffList(QObject *parent = nullptr);
    CStoreStaffList(const CStoreStaffList &,QObject *parent = nullptr);
    QSharedPointer<CAction> process(const QSharedPointer<CAction>& action ) override;

    QList<Staff*> staffList() const;
    void setStaffList(const QList<Staff*> &staffList);

    static void registerQmlType(){
        qmlRegisterType<CStoreStaffList>("CStore", 1, 0, "CStoreStaffList");
    }
private:
    QList<Staff*> m_staffList;
private slots:
    void onSaveStaffListFile();
signals:
    void staffListChanged();
};
Q_DECLARE_METATYPE(CStoreStaffList);

#endif // CSTORESTAFFLIST_H
