#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>


#include "./qtflux/cstore.h"
#include "./qtflux/caction.h"
#include "./qtflux/cdispatcher.h"
#include "./qtflux/cstoreqml.h"
#include "./qtflux/cservice.h"

#include "actiontypes.h"
#include "cmainstore.h"
#include "cmainservice.h"
#include "cstorestafflist.h"
#include "staff.h"

int main(int argc, char *argv[])
{
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    QGuiApplication app(argc, argv);

    QQmlApplicationEngine engine;

    CStoreQml::registerQmlType();
    CActionType::registerQmlType();

    engine.rootContext()->setContextProperty("appDispatcher", &CDispatcher::instance());

    // create main store
    QSharedPointer<CMainStore> st(new CMainStore());
    // create service
    QSharedPointer<CMainService> service(new CMainService());


    // register mainstore to dispatcher
    CDispatcher::instance().registerMainStore(st);
    //register middleware to dispatcher
    CDispatcher::instance().registerMainMiddleware(service);

    const QUrl url(QStringLiteral("qrc:/main.qml"));
    QObject::connect(&engine, &QQmlApplicationEngine::objectCreated,
                     &app, [url](QObject *obj, const QUrl &objUrl) {
        if (!obj && url == objUrl)
            QCoreApplication::exit(-1);

    }, Qt::QueuedConnection);
    engine.load(url);

    //Load staff managemetnPage
    CDispatcher::instance().dispatch(CActionType::MainScreen_Load,"");

//    //Write staff list to file when application close
//    QObject::connect(&app, &QGuiApplication::aboutToQuit,
//                     &app, []() {
//        CDispatcher::instance().dispatch(CActionType::StaffManagementPage_Save,"");
//    }, Qt::DirectConnection);

    return app.exec();
}

