#ifndef STAFF_H
#define STAFF_H

#include <QObject>
#include <QUuid>
#include <QFile>
#include <QTextStream>
#include <QDir>

class Staff : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QUuid id READ id WRITE setId NOTIFY idChanged)
    Q_PROPERTY(QString name READ name WRITE setName NOTIFY nameChanged)
    Q_PROPERTY(QString department READ department WRITE setDepartment NOTIFY departmentChanged)
    Q_PROPERTY(int yearsOfWork READ yearsOfWork WRITE setYearsOfWork NOTIFY yearsOfWorkChanged)

private:
    QUuid   m_id;
    QString m_name;
    QString m_department;
    int     m_yearsOfWork;

public:
    Staff();
    QUuid id() const;
    void setId(const QUuid &id);
    QString name() const;
    void setName(const QString &name);
    QString department() const;
    void setDepartment(const QString &department);
    int yearsOfWork() const;
    void setYearsOfWork(int yearsOfWork);



signals:
    void idChanged(QUuid id);
    void nameChanged(QString name);
    void departmentChanged(QString department);
    void yearsOfWorkChanged(int yearsNum);
};

#endif // STAFF_H
