#include "stafflistdbfile.h"

StaffListDBFile::StaffListDBFile(QObject *parent) : QObject(parent)
{

}
void StaffListDBFile::loadStaffListFromFile(const QString &filePath, QList<Staff*> &result)
{
    // free current memory
    foreach(Staff* st, result)
    {
        st->deleteLater();
    }
    result.clear();

    // read staff list from file
    QFile file(filePath);
    QStringList staffStr;
    if(file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        QTextStream textStream (&file);
        textStream.setCodec("UTF-8");
        while (!textStream.atEnd())
        {
            staffStr = textStream.readLine().split(";");
            if(staffStr.size() >= 3)
            {
                Staff* newStaff = new Staff();
                newStaff->setId(QUuid::createUuid());
                newStaff->setName(staffStr[0]);
                newStaff->setDepartment(staffStr[1]);
                newStaff->setYearsOfWork(staffStr[2].toInt());
                result.push_back(newStaff);
            }
        }
        file.close();
    }
}

void StaffListDBFile::writeStaffListToFile(const QString &filePath, const QList<Staff *> &result)
{
    // write staff list to file
    QFile file(filePath);
    QString staffStr;
    if(file.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        foreach(Staff* st, result)
        {
            staffStr = QString("%1;%2;%3\n").arg(st->name()).arg(st->department()).arg(st->yearsOfWork());
            file.write(staffStr.toUtf8());
        }
        file.close();
    }
}
