#ifndef CACTION_H
#define CACTION_H

#include <QObject>
#include <QVariant>
namespace qtflux {

class CAction : public QObject
{
    Q_OBJECT
    Q_PROPERTY(unsigned int actionType READ actionType WRITE setActionType NOTIFY actionTypeChanged)
    Q_PROPERTY(QVariant value READ value WRITE setValue NOTIFY valueChanged)
public:
    explicit CAction(QObject *parent = nullptr);
    CAction (int type,QVariant &value,QObject *parent = nullptr);

    int actionType() const;
    void setActionType(int actionType);

    QVariant value() const;
    void setValue(const QVariant &value);
    CAction(CAction&&) = default;
    CAction& operator=(const CAction&) = default;
    CAction& operator=(CAction&&) = default;


private:
    int             m_actionType;
    QVariant        m_value;

signals:
    void actionTypeChanged();
    void valueChanged();
};
}
#endif // CACTION_H
