#include "cdispatcher.h"
#include <QDebug>

using namespace qtflux;

CDispatcher::CDispatcher(QObject *parent) : QObject(parent)
  ,m_middleware(nullptr)
  ,m_store(nullptr)
{
   QObject::connect(this,SIGNAL(newAction()),this,SLOT(onNewActionAdded()),Qt::QueuedConnection);
}

void CDispatcher::dispatch(const QSharedPointer<CAction> &action)
{
    Q_ASSERT(m_store);
    QMutexLocker locker(&m_mutex);
    m_actions.enqueue(action);
    emit newAction();
}

void CDispatcher::dispatch(int type, QVariant payload)
{
    QSharedPointer<CAction> tt;
    tt.reset(new CAction(type,payload));
    dispatch(tt);
}

void CDispatcher::dispatchQml(int type, QVariant payload)
{
    dispatch(type,payload);
}

void CDispatcher::registerMainStore(const QSharedPointer<CStore> st)
{
    qDebug() << "Register Mainstore to dispatcher.";
    Q_ASSERT(!m_store);
    m_store = st;
}

QSharedPointer<CStore> CDispatcher::getMainStore() const
{
    return m_store;
}

void CDispatcher::registerMainMiddleware(const QSharedPointer<CService> middleware)
{
    qDebug() << "Register MainMiddleware to dispatcher.";
    Q_ASSERT(!m_middleware);
    m_middleware = middleware;
}

QSharedPointer<CService> CDispatcher::getMainMiddleware() const
{
    return m_middleware;
}

void CDispatcher::onNewActionAdded()
{
    m_mutex.lock();

    while (!m_actions.empty()) {
        auto action = m_actions.dequeue();
        m_mutex.unlock();
        // send to services
        action = m_middleware->process(action);
        // send to stores
        m_store->process(action);

        m_mutex.lock();
    }
    m_mutex.unlock();
}

