#ifndef CDISPATCHER_H
#define CDISPATCHER_H

#include <QObject>
#include <QQueue>
#include <QSharedPointer>
#include <QMutexLocker>
#include <QMutex>

#include "caction.h"
#include "cstore.h"
#include "cservice.h"

namespace qtflux {

    class CDispatcher : public QObject
    {
        Q_OBJECT
    public:
        explicit CDispatcher(QObject *parent = nullptr);

        static CDispatcher &instance() {
            static CDispatcher self;
            return self;
        }

        void dispatch(const QSharedPointer<CAction> &action);
        void dispatch(int type, QVariant payload);
        Q_INVOKABLE void dispatchQml(int type,QVariant payload);

        void registerMainStore(const QSharedPointer<CStore> st);
        QSharedPointer<CStore> getMainStore() const;
        void registerMainMiddleware(const QSharedPointer<CService> middleware);
        QSharedPointer<CService> getMainMiddleware() const;

    private:
        QSharedPointer<CService>         m_middleware;
        QSharedPointer<CStore>              m_store;
        QQueue<QSharedPointer<CAction>>     m_actions;
        QMutex                              m_mutex;
    signals:
        void newAction();
    public slots:
        void onNewActionAdded();
    };
}
#endif // CDISPATCHER_H
