#include "cstoreqml.h"

using namespace qtflux;

CStoreQml *CStoreQml::m_instance = nullptr;
CStoreQml::CStoreQml(QObject *parent) : QObject(parent)
  ,m_appDispatcher(0)
  ,m_store(0)
{
    QObject::connect(this,SIGNAL(bindSourceChanged()),this,SLOT(setupDispatcher()));
}

void CStoreQml::setAppDispatcher(const QPointer<QObject> &dispatcher)
{
    m_appDispatcher = dispatcher;
    bindSourceChanged();
}

void CStoreQml::registerMainStore( QSharedPointer<CStore> mstore)
{
    qDebug() << "create link from store to qml";
    Q_ASSERT(!m_store);
    m_store = mstore;
    QObject::connect(m_store.data(), &CStore::dispatched,this,&CStoreQml::dispatched);
}

QPointer<QObject> CStoreQml::appDispatcher() const
{
    return m_appDispatcher;
}

void CStoreQml::setupDispatcher()
{
    CDispatcher *dis = 0;
    dis = qobject_cast<CDispatcher*>(m_appDispatcher);
    registerMainStore(dis->getMainStore());
}

void CStoreQml::onDispatcherTest(int type, QVariant payload)
{
    qDebug() << "c++ receive dispatch:" << type;
}

CStore *CStoreQml::store() const
{
    Q_ASSERT(m_store);
    return m_store.data();
}
