#ifndef CSTOREQML_H
#define CSTOREQML_H

#include <QObject>
#include "cdispatcher.h"
#include "cstore.h"
#include <QtQml>

namespace qtflux {

    class CStoreQml : public QObject
    {
        Q_OBJECT
        Q_PROPERTY(QObject* appDispatcher READ appDispatcher WRITE setAppDispatcher NOTIFY bindSourceChanged)
        Q_PROPERTY(CStore* store READ store NOTIFY dispatched)
    public:
        explicit CStoreQml(QObject *parent = nullptr);
        static CStoreQml &instance(){
            Q_ASSERT(CStoreQml::m_instance);
            return *CStoreQml::m_instance;
        }
        static CStoreQml   *qmlAttachedProperties(QObject *object) {
            qDebug() << "CStoreQml   *qmlAttachedProperties";
            if( CStoreQml::m_instance == nullptr)
            {
                m_instance = new CStoreQml(object);
            }
            return m_instance;
        };

        QPointer<QObject> appDispatcher() const;
        void setAppDispatcher(const QPointer<QObject> &dispatcher);

        static void registerQmlType(){
            qmlRegisterType<CStoreQml>("CStore", 1, 0, "StoreQml");
        }
        CStore *store() const;

    private:
        QPointer<QObject>           m_appDispatcher;
        static  CStoreQml           *m_instance;
        QSharedPointer<CStore>      m_store;

        void registerMainStore(const QSharedPointer<CStore> mstore);

    public slots:
        void setupDispatcher();
        void onDispatcherTest(int type,QVariant payload);

    signals:
        void bindSourceChanged();
        void dispatched(int type,QVariant payload);
    };
}
QML_DECLARE_TYPEINFO(qtflux::CStoreQml, QML_HAS_ATTACHED_PROPERTIES)
#endif // CSTOREQML_H
